/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.model;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.inventory.Slot;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.CustomNpcs;
import noppes.npcs.ModelPartConfig;
import noppes.npcs.client.gui.model.GuiCreationScreenInterface;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcSlider;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiNpcSlider;
import noppes.npcs.client.gui.util.ISliderListener;
import noppes.npcs.constants.EnumParts;
import noppes.npcs.containers.ContainerLayer;
import noppes.npcs.entity.EntityNPCInterface;

public class GuiCreationScale
extends GuiCreationScreenInterface
implements ISliderListener,
ICustomScrollListener {
    private static EnumParts selected = EnumParts.HEAD;
    private final List<EnumParts> data = new ArrayList<EnumParts>();
    private GuiCustomScroll scroll;

    public GuiCreationScale(EntityNPCInterface npc, ContainerLayer container) {
        super(npc, container);
        this.active = 3;
        this.xOffset = 140;
    }

    @Override
    protected void func_146284_a(@Nonnull GuiButton guibutton) {
        super.func_146284_a(guibutton);
        if (guibutton.field_146127_k == 13) {
            this.playerdata.getPartConfig((EnumParts)GuiCreationScale.selected).notShared = ((GuiNpcButton)guibutton).getValue() == 0;
            this.func_73866_w_();
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (!CustomNpcs.ShowDescriptions) {
            return;
        }
        if (this.getButton(1) != null && this.getButton(1).isHovered()) {
            this.setHoverText(new TextComponentTranslation("display.hover.part.entity", new Object[0]).func_150254_d(), new Object[0]);
        } else if (this.getButton(2) != null && this.getButton(2).isHovered()) {
            this.setHoverText(new TextComponentTranslation("display.hover.parts", new Object[0]).func_150254_d(), new Object[0]);
        } else if (this.getButton(3) != null && this.getButton(3).isHovered()) {
            this.setHoverText(new TextComponentTranslation("display.hover.part.size", new Object[0]).func_150254_d(), new Object[0]);
        } else if (this.getButton(4) != null && this.getButton(4).isHovered()) {
            this.setHoverText(new TextComponentTranslation("display.hover.part.save", new Object[0]).func_150254_d(), new Object[0]);
        } else if (this.getButton(5) != null && this.getButton(5).isHovered()) {
            this.setHoverText(new TextComponentTranslation("display.hover.part.load", new Object[0]).func_150254_d(), new Object[0]);
        } else if (this.getButton(13) != null && this.getButton(13).isHovered()) {
            this.setHoverText(new TextComponentTranslation("display.hover.part.pattern", new Object[0]).func_150254_d(), new Object[0]);
        } else if (this.getButton(66) != null && this.getButton(66).isHovered()) {
            this.setHoverText(new TextComponentTranslation("hover.back", new Object[0]).func_150254_d(), new Object[0]);
        } else {
            for (GuiButton b : this.field_146292_n) {
                if (b == null || !b.func_146115_a()) continue;
                if (b.field_146127_k == 10) {
                    this.setHoverText(new TextComponentTranslation("hover.scale.x", new Object[0]).func_150254_d(), new Object[0]);
                    continue;
                }
                if (b.field_146127_k == 11) {
                    this.setHoverText(new TextComponentTranslation("hover.scale.y", new Object[0]).func_150254_d(), new Object[0]);
                    continue;
                }
                if (b.field_146127_k == 12) {
                    this.setHoverText(new TextComponentTranslation("hover.scale.z", new Object[0]).func_150254_d(), new Object[0]);
                    continue;
                }
                if (b.field_146127_k != 500) continue;
                this.setHoverText(new TextComponentTranslation("display.hover.part.rotate", new Object[0]).func_150254_d(), new Object[0]);
            }
        }
        this.drawHoverText(null, new Object[0]);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.scroll == null) {
            this.scroll = new GuiCustomScroll(this, 0);
        }
        ArrayList<String> list = new ArrayList<String>();
        EnumParts[] parts = new EnumParts[]{EnumParts.HEAD, EnumParts.BODY, EnumParts.ARM_LEFT, EnumParts.ARM_RIGHT, EnumParts.LEG_LEFT, EnumParts.LEG_RIGHT};
        this.data.clear();
        for (EnumParts part : parts) {
            ModelPartConfig config;
            if (part == EnumParts.ARM_RIGHT) {
                config = this.playerdata.getPartConfig(EnumParts.ARM_LEFT);
                if (!config.notShared) continue;
            }
            if (part == EnumParts.LEG_RIGHT) {
                config = this.playerdata.getPartConfig(EnumParts.LEG_LEFT);
                if (!config.notShared) continue;
            }
            this.data.add(part);
            list.add(new TextComponentTranslation("part." + part.name, new Object[0]).func_150254_d());
        }
        this.scroll.setListNotSorted(list);
        this.scroll.setSelected(new TextComponentTranslation("part." + GuiCreationScale.selected.name, new Object[0]).func_150254_d());
        this.scroll.guiLeft = this.field_147003_i;
        this.scroll.guiTop = this.field_147009_r + 46;
        this.scroll.setSize(100, this.field_147000_g - 74);
        this.addScroll(this.scroll);
        ModelPartConfig config2 = this.playerdata.getPartConfig(selected);
        int y = this.field_147009_r + 65;
        this.addLabel(new GuiNpcLabel(10, "scale.width", this.field_147003_i + 102, y + 5, 0xFFFFFF));
        this.addSlider(new GuiNpcSlider(this, 10, this.field_147003_i + 150, y, 100, 20, config2.scale[0] - 0.5f));
        this.addLabel(new GuiNpcLabel(11, "scale.height", this.field_147003_i + 102, (y += 22) + 5, 0xFFFFFF));
        this.addSlider(new GuiNpcSlider(this, 11, this.field_147003_i + 150, y, 100, 20, config2.scale[1] - 0.5f));
        this.addLabel(new GuiNpcLabel(12, "scale.depth", this.field_147003_i + 102, (y += 22) + 5, 0xFFFFFF));
        this.addSlider(new GuiNpcSlider(this, 12, this.field_147003_i + 150, y, 100, 20, config2.scale[2] - 0.5f));
        if (selected == EnumParts.ARM_LEFT || selected == EnumParts.LEG_LEFT) {
            this.addLabel(new GuiNpcLabel(13, "scale.shared", this.field_147003_i + 102, (y += 22) + 5, 0xFFFFFF));
            this.addButton(new GuiNpcButton(13, this.field_147003_i + 150, y, 50, 20, new String[]{"gui.no", "gui.yes"}, config2.notShared ? 0 : 1));
        }
        for (Slot slot : this.field_147002_h.field_75151_b) {
            slot.field_75223_e = -5000;
            slot.field_75221_f = -5000;
        }
    }

    @Override
    public void mouseDragged(IGuiNpcSlider slider) {
        super.mouseDragged(slider);
        if (slider.getID() >= 10 && slider.getID() <= 12) {
            int percent = (int)(50.0f + slider.getSliderValue() * 100.0f);
            slider.setString(percent + "%");
            ModelPartConfig config = this.playerdata.getPartConfig(selected);
            if (slider.getID() == 10) {
                config.scale[0] = slider.getSliderValue() + 0.5f;
            }
            if (slider.getID() == 11) {
                config.scale[1] = slider.getSliderValue() + 0.5f;
            }
            if (slider.getID() == 12) {
                config.scale[2] = slider.getSliderValue() + 0.5f;
            }
            this.updateTranslate();
        }
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int mouseButton, IGuiCustomScroll scroll) {
        if (scroll.getSelect() >= 0) {
            selected = this.data.get(scroll.getSelect());
            this.func_73866_w_();
        }
    }

    @Override
    public void scrollDoubleClicked(String selection, IGuiCustomScroll scroll) {
    }

    private void updateTranslate() {
        for (EnumParts part : EnumParts.values()) {
            float y;
            float x;
            ModelPartConfig body;
            ModelPartConfig config = this.playerdata.getPartConfig(part);
            if (config == null) continue;
            if (part == EnumParts.HEAD) {
                config.setTranslate(0.0f, this.playerdata.getBodyY(), 0.0f);
                continue;
            }
            if (part == EnumParts.ARM_LEFT) {
                body = this.playerdata.getPartConfig(EnumParts.BODY);
                x = (1.0f - body.scale[0]) * 0.25f + (1.0f - config.scale[0]) * 0.075f;
                y = this.playerdata.getBodyY() + (1.0f - config.scale[1]) * -0.1f;
                config.setTranslate(-x, y, 0.0f);
                if (config.notShared) continue;
                ModelPartConfig arm = this.playerdata.getPartConfig(EnumParts.ARM_RIGHT);
                arm.copyValues(config);
                continue;
            }
            if (part == EnumParts.ARM_RIGHT) {
                body = this.playerdata.getPartConfig(EnumParts.BODY);
                x = (1.0f - body.scale[0]) * 0.25f + (1.0f - config.scale[0]) * 0.075f;
                y = this.playerdata.getBodyY() + (1.0f - config.scale[1]) * -0.1f;
                config.setTranslate(x, y, 0.0f);
                continue;
            }
            if (part == EnumParts.LEG_LEFT) {
                config.setTranslate(config.scale[0] * 0.125f - 0.113f, this.playerdata.getLegsY(), 0.0f);
                if (config.notShared) continue;
                ModelPartConfig leg = this.playerdata.getPartConfig(EnumParts.LEG_RIGHT);
                leg.copyValues(config);
                continue;
            }
            if (part == EnumParts.LEG_RIGHT) {
                config.setTranslate((1.0f - config.scale[0]) * 0.125f, this.playerdata.getLegsY(), 0.0f);
                continue;
            }
            if (part != EnumParts.BODY) continue;
            config.setTranslate(0.0f, this.playerdata.getBodyY(), 0.0f);
        }
    }
}

